// DffDlg.cpp : implementation file
//

#include "stdafx.h"
#include "version.h"
#include "RwExp.h"
#include "DffDlg.h"
#include "hlp\helpcontexts.h"
#include "osutils.h"

#include "rwcore.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDffDlg dialog

//build mapping array for the help system
//there is one pair of entries in this array for each #define
//in helpcontexts.h
DWORD CDffDlg::m_helpMappingArray[] = {
        IDC_DFF_DEFAULT,HIDC_DFF_DEFAULT,
        IDC_DFF_SCALEFACTOR,HIDC_DFF_SCALEFACTOR,
        IDC_DFF_SETDEFAULTS,HIDC_DFF_SETDEFAULTS,
        IDC_BSP_DEFAULT,HIDC_BSP_DEFAULT,
        IDC_BSP_SCALEFACTOR,HIDC_BSP_SCALEFACTOR,
        IDC_BSP_SETDEFAULT,HIDC_BSP_SETDEFAULT,
        IDC_TEXTUREMETHOD,HIDC_TEXTUREMETHOD,
        IDC_SAVEANIMATION,HIDC_SAVEANIMATION,
        IDC_SAVEMORPHTARGETS,HIDC_SAVEMORPHTARGETS,
        IDC_FRAMETAGS,HIDC_FRAMETAGS,
        IDC_ATOMICTAGS,HIDC_ATOMICTAGS,
        IDC_WELDVERTS,HIDC_WELDVERTS,
        IDC_WELD_THRESHOLD,HIDC_WELD_THRESHOLD,
        IDC_ANM_SCALEFACTOR,HIDC_ANM_SCALEFACTOR,
        IDC_ALLMATS,HIDC_ALLMATS,
        IDC_PRELIGHT,HIDC_PRELIGHT,
        IDC_SCALEBY,HIDC_SCALEBY,
        IDC_SCALETO,HIDC_SCALETO,
        IDC_TMVERTS,HIDC_TMVERTS,
        IDC_TMPOLYS,HIDC_TMPOLYS,
        IDC_WORLDPRELIGHT,HIDC_WORLDPRELIGHT,
        IDC_BSPTEXFILTERCOMBO,HIDC_BSPTEXFILTERCOMBO,
        IDC_DFFTEXFILTERCOMBO,HIDC_DFFTEXFILTERCOMBO,
        IDC_RWPRELIGHT,HIDC_RWPRELIGHT,
        IDC_WORLDSECTOR_SIZEX,HIDC_WORLDSECTOR_SIZEX,
        IDC_WORLDSECTOR_SIZE,HIDC_WORLDSECTOR_SIZE,
        IDC_WORLDSECTOR_SIZEY,HIDC_WORLDSECTOR_SIZEY,
        IDC_SAVESEQANIM,HIDC_SAVESEQANIM,
        IDC_WORLDSECTOR_SIZEZ,HIDC_WORLDSECTOR_SIZEZ,
        IDC_ANIMFRAMEINTERVAL,HIDC_ANIMFRAMEINTERVAL,
        IDC_WORLDSECTOR_MAXPOLYS,HIDC_WORLDSECTOR_MAXPOLYS,
        IDC_DFF_SAVEDEFAULT,HIDC_DFF_SAVEDEFAULT,
        IDC_WELDTHRESHOLD,HIDC_WELDTHRESHOLD,
        IDC_WELDTHRESHOLDUV,HIDC_WELDTHRESHOLDUV,
        IDC_SAVEANIM2,HIDC_SAVEANIM2,
        IDC_DFFSMOOTHING,HIDC_DFFSMOOTHING,
        IDC_DFFWELDTHRESHOLDUV,HIDC_DFFWELDTHRESHOLDUV,
        IDC_BSPSMOOTHING,HIDC_BSPSMOOTHING,
        IDC_MAXPLANECHECK,HIDC_MAXPLANECHECK,
        IDC_OBJINWORLDSPACE,HIDC_OBJINWORLDSPACE,
        IDC_NAMEDSETVERTS,HIDC_NAMEDSETVERTS,
        IDC_SMOOTHNORMALS,HIDC_SMOOTHNORMALS,
        IDC_TRISTRIP,HIDC_TRISTRIP,
        IDC_MAXSECTOROVERLAP,HIDC_MAXSECTOROVERLAP,
        IDC_NOALPHAINOVERLAP,HIDC_NOALPHAINOVERLAP,
        IDC_CLAMPUVS,HIDC_CLAMPUVS,
        IDC_CLAMPUVSMAX,HIDC_CLAMPUVSMAX,
        IDC_LIMITUVS,HIDC_LIMITUVS,
        IDC_LIMITUVSMAX,HIDC_LIMITUVSMAX,
        IDC_DFFWELDTHRESHOLD,HIDC_DFFWELDTHRESHOLD,
        IDC_SCALE,HIDC_SCALE,
        IDC_DFF2SIDEDMATS,HIDC_DFF2SIDEDMATS,
        IDC_DFF2SIDEDNORMALS,HIDC_DFF2SIDEDNORMALS,
        IDC_BSP2SIDEDMATS,HIDC_BSP2SIDEDMATS,
        IDC_BSP2SIDEDNORMALS,HIDC_BSP2SIDEDNORMALS,
        IDC_CSEXPORT,HIDC_CSEXPORT,
        IDC_NORMALS,HIDC_NORMALS,
        IDC_VERTEXCOLORS,HIDC_VERTEXCOLORS,
        IDC_LITGEOM,HIDC_LITGEOM,
        IDC_VERTCOLPRELIGHT,HIDC_VERTCOLPRELIGHT,
        IDC_COLORVERTEXPRELIGHT,HIDC_COLORVERTEXPRELIGHT,
        IDC_DFFWELDING,HIDC_DFFWELDING,
        IDC_BSPWELDING,HIDC_BSPWELDING,
        IDC_DEFAULTANIMNAME,HIDC_DEFAULTANIMNAME,
        IDC_ORIGCASE,HIDC_ORIGCASE,
        IDC_LOWERCASE,HIDC_LOWERCASE,
        IDC_UPPERCASE,HIDC_UPPERCASE,
        IDC_CONDGEOM,HIDC_CONDGEOM,
        IDC_EXPORTLABELS,HIDC_EXPORTLABELS,
        IDC_WORLDNORMALS,HIDC_WORLDNORMALS,
        IDC_CSTOPLEVELKEYS,HIDC_CSTOPLEVELKEYS,
        IDC_BSPOFFSETX,HIDC_BSPOFFSETX,
        IDC_BSPOFFSETY,HIDC_BSPOFFSETY,
        IDC_BSPOFFSETZ,HIDC_BSPOFFSETZ,
        IDC_MAXNATIVESKIN,HIDC_MAXNATIVESKIN,
        IDC_NOEXTRAINTERPKEYS,HIDC_NOEXTRAINTERPKEYS,
        IDC_INTERPOLATION,HIDC_INTERPOLATION,
        IDC_WARNINGSLISTVIEW,HIDC_WARNINGSLISTVIEW,
        IDC_ERRORS,HIDC_ERRORS,
        IDC_GENFILE,HIDC_GENFILE,
        IDC_DISPLAYREPORT,HIDC_DISPLAYREPORT,
        IDD_DFF_DIALOG,HIDD_DFF_DIALOG,   
        IDD_BSP_DIALOG,HIDD_BSP_DIALOG,   
        IDD_ANM_DIALOG,HIDD_ANM_DIALOG,   
        IDD_SPL_DIALOG,HIDD_SPL_DIALOG,   
        IDD_WARNING_DIALOG,HIDD_WARNING_DIALOG,   
        IDC_STATIC,HIDC_STATIC,
        IDC_MORPHINTERVALTEXT,HIDC_MORPHINTERVALTEXT,
        IDC_WELDVERTSTEXT,HIDC_WELDVERTSTEXT,
        IDC_WELDUVSTEXT,HIDC_WELDUVSTEXT,
        IDC_MAXUVTEXT,HIDC_MAXUVTEXT,
        IDC_ANIDEFNAMETEXT,HIDC_ANIDEFNAMETEXT,
        IDC_LEGACYOPTIONS,HIDC_LEGACYOPTIONS,
        IDC_SKINSKA,HIDC_SKINSKA,
        IDC_HANIM,HIDC_HANIM,
        IDC_NOHANIMMATRICES,HIDC_NOHANIMMATRICES,
        IDC_HANIMLOCALSPACEMATRICES,HIDC_HANIMLOCALSPACEMATRICES,
        IDC_SUBHIERARCHYANIM,HIDC_SUBHIERARCHYANIM,
        0,0
    };

CDffDlg::CDffDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CDffDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CDffDlg)
    m_suppressPrompts = FALSE;
    m_nScaleFactor = 0.0f;
    m_preLightClump = FALSE;
    m_nScaleType = -1;
    m_seqAnim = FALSE;
    m_nAnimFrameInterval = 0;
    m_morphTargets = FALSE;
    m_anim = FALSE;
    m_retainObjInWorldSpace = FALSE;
    m_linkBySelSets = FALSE;
    m_triStripMesh = FALSE;
    m_limitUVs = FALSE;
    m_limitUVMax = 0;
    m_weldThreshold = 0.0f;
    m_weldThresholdUV = 0.0f;
    m_backfaceNormals = FALSE;
    m_2SidedMaterials = FALSE;
    m_CSExport = FALSE;
    m_maxNativeSkin = FALSE;
    m_exportNormals = FALSE;
    m_exportLit = FALSE;
    m_colorVertexPrelight = FALSE;
    m_weldVertices = FALSE;
    m_defaultAnimName = _T("default");
    m_texturenameCase = -1;
    m_exportLabels = FALSE;
    m_filterTopLevelCSKeys = FALSE;
    m_NoExtraInterpKeys = FALSE;
    m_generateReportFile = FALSE;
    m_displayReport = FALSE;
    m_legacyOptions = FALSE;
	m_exportHAnim = FALSE;
	m_skinSKA = FALSE;
	m_HAnimNoMatrices = FALSE;
	m_HAnimSubHierarchyAnim = FALSE;
	m_HAnimLocalSpaceMatrices = FALSE;
	//}}AFX_DATA_INIT
}


void CDffDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CDffDlg)    
    DDX_Text(pDX, IDC_DFF_SCALEFACTOR, m_nScaleFactor);
    DDV_MinMaxFloat(pDX, m_nScaleFactor, 0.f, 1.e+025f);
    DDX_Check(pDX, IDC_PRELIGHT, m_preLightClump);
    DDX_Radio(pDX, IDC_SCALEBY, m_nScaleType);
    DDX_Check(pDX, IDC_SAVESEQANIM, m_seqAnim);
    DDX_Text(pDX, IDC_ANIMFRAMEINTERVAL, m_nAnimFrameInterval);
    DDX_Check(pDX, IDC_SAVEMORPHTARGETS, m_morphTargets);
    DDX_Check(pDX, IDC_SAVEANIM2, m_anim);
    DDX_Check(pDX, IDC_OBJINWORLDSPACE, m_retainObjInWorldSpace);
    DDX_Check(pDX, IDC_NAMEDSETVERTS, m_linkBySelSets);
    DDX_Check(pDX, IDC_TRISTRIP, m_triStripMesh);
    DDX_Check(pDX, IDC_LIMITUVS, m_limitUVs);
    DDX_Text(pDX, IDC_LIMITUVSMAX, m_limitUVMax);
    DDX_Text(pDX, IDC_DFFWELDTHRESHOLD, m_weldThreshold);
    DDX_Text(pDX, IDC_DFFWELDTHRESHOLDUV, m_weldThresholdUV);
    DDX_Check(pDX, IDC_DFF2SIDEDNORMALS, m_backfaceNormals);
    DDX_Check(pDX, IDC_DFF2SIDEDMATS, m_2SidedMaterials);
    DDX_Check(pDX, IDC_CSEXPORT, m_CSExport);
    DDX_Check(pDX, IDC_MAXNATIVESKIN, m_maxNativeSkin);
    DDX_Check(pDX, IDC_NORMALS, m_exportNormals);
    DDX_Check(pDX, IDC_LITGEOM, m_exportLit);
    DDX_Check(pDX, IDC_VERTCOLPRELIGHT, m_colorVertexPrelight);
    DDX_Check(pDX, IDC_DFFWELDING, m_weldVertices);
    DDX_Text(pDX, IDC_DEFAULTANIMNAME, m_defaultAnimName);
    DDX_Radio(pDX, IDC_ORIGCASE, m_texturenameCase);
    DDX_Check(pDX, IDC_EXPORTLABELS, m_exportLabels);
    DDX_Check(pDX, IDC_CSTOPLEVELKEYS, m_filterTopLevelCSKeys);
    DDX_Check(pDX, IDC_NOEXTRAINTERPKEYS, m_NoExtraInterpKeys);
    DDX_Check(pDX, IDC_GENFILE, m_generateReportFile);
    DDX_Check(pDX, IDC_DISPLAYREPORT, m_displayReport);
    DDX_Check(pDX, IDC_LEGACYOPTIONS, m_legacyOptions);
	DDX_Check(pDX, IDC_HANIM, m_exportHAnim);
	DDX_Check(pDX, IDC_SKINSKA, m_skinSKA);
	DDX_Check(pDX, IDC_NOHANIMMATRICES, m_HAnimNoMatrices);
	DDX_Check(pDX, IDC_SUBHIERARCHYANIM, m_HAnimSubHierarchyAnim);
	DDX_Check(pDX, IDC_HANIMLOCALSPACEMATRICES, m_HAnimLocalSpaceMatrices);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDffDlg, CDialog)
    //{{AFX_MSG_MAP(CDffDlg)
    ON_BN_CLICKED(IDC_DFF_DEFAULT, OnDffDefault)
    ON_BN_CLICKED(IDC_DFF_SETDEFAULTS, OnDffSetDefaults)
    ON_BN_CLICKED(IDC_DFFWELDING, DFFWeldingButtonClick )
    ON_BN_CLICKED(IDC_LIMITUVS, LimitUVButtonClick )
    ON_BN_CLICKED(IDC_SAVEMORPHTARGETS, SaveMorphTargetsButtonClick )
    ON_BN_CLICKED(IDC_LEGACYOPTIONS, LegacyOptionsButtonClick )
    ON_NOTIFY_EX( TTN_NEEDTEXT, 0, OnToolTipNotify )
    ON_WM_CONTEXTMENU()
    ON_WM_HELPINFO()
    ON_BN_CLICKED(IDC_HELPBUTTON, OnHelpButton)
	ON_BN_CLICKED(IDC_MAXNATIVESKIN, MaxNativeSkinButtonClick)
	ON_BN_CLICKED(IDC_CSEXPORT, CSExportButtonClick)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDffDlg message handlers

void CDffDlg::OnDffDefault() 
{
    DWORD Disposition;
    HKEY SettingsKey;
    char buffer[256];    
    unsigned long size, value;

    RegCreateKeyEx (HKEY_CURRENT_USER, 
                    "Software\\Criterion\\RenderWare3\\3DSMax Exporter\\DFF Exporter", 0,
                    REG_NONE, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, 
                    &SettingsKey, &Disposition);    
    size = 255;
    if (RegQueryValueEx (SettingsKey, "Scale Factor", NULL, NULL, (unsigned char *)buffer, &size) != ERROR_SUCCESS)
    {
        m_nScaleFactor = 1.0f;
        sprintf(buffer, "%f", m_nScaleFactor);
        RegSetValueEx (SettingsKey, "Scale Factor", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    }
    else
    {
        sscanf(buffer, "%f", &m_nScaleFactor);
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Save Animation", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_anim = 0;        
        RegSetValueEx (SettingsKey, "Save Animation", 0, REG_DWORD, (unsigned char *)&m_anim, 4);
    }
    else
    {
        m_anim = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Save Morph Targets", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_morphTargets = 0;        
        RegSetValueEx (SettingsKey, "Save Morph Targets", 0, REG_DWORD, (unsigned char *)&m_morphTargets, 4);
    }
    else
    {
        m_morphTargets = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Morph Anim Interval", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_nAnimFrameInterval = 1;        
        RegSetValueEx (SettingsKey, "Morph Anim Interval", 0, REG_DWORD, (unsigned char *)&m_nAnimFrameInterval, 4);
    }
    else
    {
        m_nAnimFrameInterval = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Seq Anim", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_seqAnim= 0;        
        RegSetValueEx (SettingsKey, "Seq Anim", 0, REG_DWORD, (unsigned char *)&m_seqAnim, 4);
    }
    else
    {
        m_seqAnim = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Scale Type", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_nScaleType = 0;        
        RegSetValueEx (SettingsKey, "Scale Type", 0, REG_DWORD, (unsigned char *)&m_nScaleType, 4);
    }
    else
    {
        m_nScaleType = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Pre-Lighting", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_preLightClump = 0;        
        RegSetValueEx (SettingsKey, "Pre-Lighting", 0, REG_DWORD, (unsigned char *)&m_preLightClump, 4);
    }
    else
    {
        m_preLightClump = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Link By Selection Sets", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_linkBySelSets = 0;        
        RegSetValueEx (SettingsKey, "Link By Selection Sets", 0, REG_DWORD, (unsigned char *)&m_linkBySelSets, 4);
    }
    else
    {
        m_linkBySelSets = value;
    }    
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Export In World Space", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_retainObjInWorldSpace = 0;        
        RegSetValueEx (SettingsKey, "Export In World Space", 0, REG_DWORD, (unsigned char *)&m_retainObjInWorldSpace, 4);
    }
    else
    {
        m_retainObjInWorldSpace = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "TriStripMeshes", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_triStripMesh = FALSE;
        RegSetValueEx (SettingsKey, "TriStripMeshes", 0, REG_DWORD, (unsigned char *)&m_triStripMesh, 4);
    }
    else
    {
        m_triStripMesh = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Limit UVs", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_limitUVs = FALSE;
        RegSetValueEx (SettingsKey, "Limit UVs", 0, REG_DWORD, (unsigned char *)&m_limitUVs, 4);
    }
    else
    {
        m_limitUVs = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Limit UV Max", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_limitUVMax = 16;
        RegSetValueEx (SettingsKey, "Limit UV Max", 0, REG_DWORD, (unsigned char *)&m_limitUVMax, 4);
    }
    else
    {
        m_limitUVMax = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Weld Vertices", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_weldVertices=FALSE;
        RegSetValueEx (SettingsKey, "Weld Vertices", 0, REG_DWORD, (unsigned char *)&m_weldVertices, 4);
    }
    else
    {
        m_weldVertices = value;
    }
    size = 255;
    if (RegQueryValueEx (SettingsKey, "Weld Threshold", NULL, NULL, (unsigned char *)buffer, &size) != ERROR_SUCCESS)
    {
        m_weldThreshold = 0.001f;
        sprintf(buffer, "%f", m_weldThreshold);
        RegSetValueEx (SettingsKey, "Weld Threshold", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    }
    else
    {
        sscanf(buffer, "%f", &m_weldThreshold);
    }
    size = 255;
    if (RegQueryValueEx (SettingsKey, "Weld Threshold UV", NULL, NULL, (unsigned char *)buffer, &size) != ERROR_SUCCESS)
    {
        m_weldThresholdUV = 0.001f;
        sprintf(buffer, "%f", m_weldThresholdUV);
        RegSetValueEx (SettingsKey, "Weld Threshold UV", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    }
    else
    {
        sscanf(buffer, "%f", &m_weldThresholdUV);
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Export 2-Sided Materials", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_2SidedMaterials = FALSE;
        RegSetValueEx (SettingsKey, "Export 2-Sided Materials", 0, REG_DWORD, (unsigned char *)&m_2SidedMaterials, 4);
    }
    else
    {
        m_2SidedMaterials = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Backface Normals", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_backfaceNormals = FALSE;
        RegSetValueEx (SettingsKey, "Backface Normals", 0, REG_DWORD, (unsigned char *)&m_backfaceNormals, 4);
    }
    else
    {
        m_backfaceNormals = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "CS Export", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_CSExport = FALSE;
        RegSetValueEx (SettingsKey, "CS Export", 0, REG_DWORD, (unsigned char *)&m_CSExport, 4);
    }
    else
    {
        m_CSExport = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "CS Filter Top Level Keys", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_filterTopLevelCSKeys = FALSE;
        RegSetValueEx (SettingsKey, "CS Filter Top Level Keys", 0, REG_DWORD, (unsigned char *)&m_filterTopLevelCSKeys, 4);
    }
    else
    {
        m_filterTopLevelCSKeys = value;
    }   
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Max Native Skin", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_maxNativeSkin = FALSE;
        RegSetValueEx (SettingsKey, "Max Native Skins", 0, REG_DWORD, (unsigned char *)&m_maxNativeSkin, 4);
    }
    else
    {
        m_maxNativeSkin = value;
    }  
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Export Normals", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_exportNormals = TRUE;
        RegSetValueEx (SettingsKey, "Export Normals", 0, REG_DWORD, (unsigned char *)&m_exportNormals, 4);
    }
    else
    {
        m_exportNormals = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Export Lit", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_exportLit = TRUE;
        RegSetValueEx (SettingsKey, "Export Lit", 0, REG_DWORD, (unsigned char *)&m_exportLit, 4);
    }
    else
    {
        m_exportLit = value;
    }
    size = 255;
    if (RegQueryValueEx (SettingsKey, "Default Anim Name", NULL, NULL, (unsigned char *)buffer, &size) != ERROR_SUCCESS)
    {
        m_defaultAnimName = CString("default");
        sprintf(buffer, "%s", m_defaultAnimName);
        RegSetValueEx (SettingsKey, "Default Anim Name", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    }
    else
    {
        m_defaultAnimName = CString(buffer);        
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Texture Name Case", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_texturenameCase = 0;        
        RegSetValueEx (SettingsKey, "Texture Name Case", 0, REG_DWORD, (unsigned char *)&m_texturenameCase, 4);
    }
    else
    {
        m_texturenameCase = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Color Vertex Pre-Lighting", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_colorVertexPrelight = 0;        
        RegSetValueEx (SettingsKey, "Color Vertex Pre-Lighting", 0, REG_DWORD, (unsigned char *)&m_colorVertexPrelight, 4);
    }
    else
    {
        m_colorVertexPrelight = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Export RpLabels", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_exportLabels = 0;        
        RegSetValueEx (SettingsKey, "Export RpLabels", 0, REG_DWORD, (unsigned char *)&m_exportLabels, 4);
    }
    else
    {
        m_exportLabels = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "No Extra Interpolation Keys", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_NoExtraInterpKeys = 0;        
        RegSetValueEx (SettingsKey, "No Extra Interpolation Keys", 0, REG_DWORD, (unsigned char *)&m_NoExtraInterpKeys, 4);
    }
    else
    {
        m_NoExtraInterpKeys = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Generate Report File", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_generateReportFile = 0;        
        RegSetValueEx (SettingsKey, "Generate Report File", 0, REG_DWORD, (unsigned char *)&m_generateReportFile, 4);
    }
    else
    {
        m_generateReportFile = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Display Report", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_displayReport = 0;        
        RegSetValueEx (SettingsKey, "Display Report", 0, REG_DWORD, (unsigned char *)&m_displayReport, 4);
    }
    else
    {
        m_displayReport = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Export HAnim", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_exportHAnim = 0;        
        RegSetValueEx (SettingsKey, "Export HAnim", 0, REG_DWORD, (unsigned char *)&m_exportHAnim, 4);
    }
    else
    {
        m_exportHAnim = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Save SKA", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_skinSKA = 1;        
        RegSetValueEx (SettingsKey, "Save SKA", 0, REG_DWORD, (unsigned char *)&m_skinSKA, 4);
    }
    else
    {
        m_skinSKA = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "HAnimNoMatrices", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_HAnimNoMatrices = FALSE;        
        RegSetValueEx (SettingsKey, "HAnimNoMatrices", 0, REG_DWORD, (unsigned char *)&m_HAnimNoMatrices, 4);
    }
    else
    {
        m_HAnimNoMatrices = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "HAnimSubHierarchyAnim", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_HAnimSubHierarchyAnim = FALSE;        
        RegSetValueEx (SettingsKey, "HAnimSubHierarchyAnim", 0, REG_DWORD, (unsigned char *)&m_HAnimSubHierarchyAnim, 4);
    }
    else
    {
        m_HAnimSubHierarchyAnim = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "HAnimLocalSpaceMatrices", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_HAnimLocalSpaceMatrices = FALSE;        
        RegSetValueEx (SettingsKey, "HAnimLocalSpaceMatrices", 0, REG_DWORD, (unsigned char *)&m_HAnimLocalSpaceMatrices, 4);
    }
    else
    {
        m_HAnimLocalSpaceMatrices = value;
    }

    RegCloseKey (SettingsKey);    
      
    UpdateData(FALSE);        

}

BOOL CDffDlg::OnInitDialog() 
{
    string Version;
    CString ExistingTitle;

    CDialog::OnInitDialog();

    //set window text from version information
    SetWindowText(DFFExporterWindowTitle);
    
    /* Load the icon for the help button and send a message to the button. */
    HICON hIcon=AfxGetApp()->LoadIcon(IDI_HELPICON);
    CWnd *helpbutton = GetDlgItem(IDC_HELPBUTTON);
    helpbutton->SendMessage(BM_SETIMAGE,IMAGE_ICON,(LPARAM)hIcon);

    OnDffDefault();

    /* Make sure that the dialog starts up in the correct state. */
    DFFWeldingButtonClick();
    LimitUVButtonClick();
    SaveMorphTargetsButtonClick();
    LegacyOptionsButtonClick();
    MaxNativeSkinButtonClick();
    CSExportButtonClick();

    EnableToolTips(TRUE);

    //if suppressPrompts then simply click the OK button and do the export
    if (m_suppressPrompts) OnOK();

    return TRUE;  // return TRUE unless you set the focus to a control
                  // EXCEPTION: OCX Property Pages should return FALSE
}

void CDffDlg::OnOK() 
{
    // TODO: Add extra validation here    
    
    CDialog::OnOK();
}

void CDffDlg::OnDffSetDefaults() 
{
    DWORD Disposition;
    HKEY SettingsKey;
    char buffer[256];    

    UpdateData(TRUE);
    RegCreateKeyEx (HKEY_CURRENT_USER, 
                    "Software\\Criterion\\RenderWare3\\3DSMax Exporter\\DFF Exporter", 0,
                    REG_NONE, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, 
                    &SettingsKey, &Disposition);    
    
    sprintf(buffer, "%f", m_nScaleFactor);
    RegSetValueEx (SettingsKey, "Scale Factor", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    RegSetValueEx (SettingsKey, "Save Animation", 0, REG_DWORD, (unsigned char *)&m_anim, 4);
    RegSetValueEx (SettingsKey, "Save Morph Targets", 0, REG_DWORD, (unsigned char *)&m_morphTargets, 4);
    RegSetValueEx (SettingsKey, "Morph Anim Interval", 0, REG_DWORD, (unsigned char *)&m_nAnimFrameInterval, 4);
    RegSetValueEx (SettingsKey, "Seq Anim", 0, REG_DWORD, (unsigned char *)&m_seqAnim, 4);
    RegSetValueEx (SettingsKey, "Scale Type", 0, REG_DWORD, (unsigned char *)&m_nScaleType, 4);
    RegSetValueEx (SettingsKey, "Pre-Lighting", 0, REG_DWORD, (unsigned char *)&m_preLightClump, 4);    
    RegSetValueEx (SettingsKey, "Link By Selection Sets", 0, REG_DWORD, (unsigned char *)&m_linkBySelSets, 4);
    RegSetValueEx (SettingsKey, "Export In World Space", 0, REG_DWORD, (unsigned char *)&m_retainObjInWorldSpace, 4);
    RegSetValueEx (SettingsKey, "TriStripMeshes", 0, REG_DWORD, (unsigned char *)&m_triStripMesh, 4);
    RegSetValueEx (SettingsKey, "Limit UVs", 0, REG_DWORD, (unsigned char *)&m_limitUVs, 4);
    RegSetValueEx (SettingsKey, "Limit UV Max", 0, REG_DWORD, (unsigned char *)&m_limitUVMax, 4);
    RegSetValueEx (SettingsKey, "Weld Vertices", 0, REG_DWORD, (unsigned char *)&m_weldVertices, 4);
    sprintf(buffer, "%f", m_weldThreshold);
    RegSetValueEx (SettingsKey, "Weld Threshold", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    sprintf(buffer, "%f", m_weldThresholdUV);
    RegSetValueEx (SettingsKey, "Weld Threshold UV", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    RegSetValueEx (SettingsKey, "Export 2-Sided Materials", 0, REG_DWORD, (unsigned char *)&m_2SidedMaterials, 4);
    RegSetValueEx (SettingsKey, "Backface Normals", 0, REG_DWORD, (unsigned char *)&m_backfaceNormals, 4);
    RegSetValueEx (SettingsKey, "CS Export", 0, REG_DWORD, (unsigned char *)&m_CSExport, 4);
    RegSetValueEx (SettingsKey, "CS Filter Top Level Keys", 0, REG_DWORD, (unsigned char *)&m_filterTopLevelCSKeys, 4);    
    RegSetValueEx (SettingsKey, "Max Native Skin", 0, REG_DWORD, (unsigned char *)&m_maxNativeSkin, 4);
    RegSetValueEx (SettingsKey, "Export Normals", 0, REG_DWORD, (unsigned char *)&m_exportNormals, 4);
    RegSetValueEx (SettingsKey, "Export Lit", 0, REG_DWORD, (unsigned char *)&m_exportLit, 4);
    sprintf(buffer, "%s", m_defaultAnimName);
    RegSetValueEx (SettingsKey, "Default Anim Name", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    RegSetValueEx (SettingsKey, "Texture Name Case", 0, REG_DWORD, (unsigned char *)&m_texturenameCase, 4);
    RegSetValueEx (SettingsKey, "Color Vertex Pre-Lighting", 0, REG_DWORD, (unsigned char *)&m_colorVertexPrelight, 4);
    RegSetValueEx (SettingsKey, "Export RpLabels", 0, REG_DWORD, (unsigned char *)&m_exportLabels, 4);
    RegSetValueEx (SettingsKey, "No Extra Interpolation Keys", 0, REG_DWORD, (unsigned char *)&m_NoExtraInterpKeys, 4);
    RegSetValueEx (SettingsKey, "Generate Report File", 0, REG_DWORD, (unsigned char *)&m_generateReportFile, 4);
    RegSetValueEx (SettingsKey, "Display Report", 0, REG_DWORD, (unsigned char *)&m_displayReport, 4);
    RegSetValueEx (SettingsKey, "Export HAnim", 0, REG_DWORD, (unsigned char *)&m_exportHAnim, 4);
    RegSetValueEx (SettingsKey, "Save SKA", 0, REG_DWORD, (unsigned char *)&m_skinSKA, 4);
    RegSetValueEx (SettingsKey, "HAnimNoMatrices", 0, REG_DWORD, (unsigned char *)&m_HAnimNoMatrices, 4);
    RegSetValueEx (SettingsKey, "HAnimSubHierarchyAnim", 0, REG_DWORD, (unsigned char *)&m_HAnimSubHierarchyAnim, 4);
    RegSetValueEx (SettingsKey, "HAnimLocalSpaceMatrices", 0, REG_DWORD, (unsigned char *)&m_HAnimLocalSpaceMatrices, 4);

    RegCloseKey (SettingsKey);        
}


void CDffDlg::DFFWeldingButtonClick()
{
    /* Handle enable/disable of dff welding controls when radio button is clicked. */
    CWnd *weldvertstext=GetDlgItem(IDC_WELDVERTSTEXT);
    if (weldvertstext) {
        weldvertstext->EnableWindow(IsDlgButtonChecked(IDC_DFFWELDING));
    }
    CWnd *dffweldthreshold=GetDlgItem(IDC_DFFWELDTHRESHOLD);
    if (dffweldthreshold) {
        dffweldthreshold->EnableWindow(IsDlgButtonChecked(IDC_DFFWELDING));
    }
    CWnd *welduvstext=GetDlgItem(IDC_WELDUVSTEXT);
    if (welduvstext) {
        welduvstext->EnableWindow(IsDlgButtonChecked(IDC_DFFWELDING));
    }
    CWnd *dffweldthresholduv=GetDlgItem(IDC_DFFWELDTHRESHOLDUV);
    if (dffweldthresholduv) {
        dffweldthresholduv->EnableWindow(IsDlgButtonChecked(IDC_DFFWELDING));
    }
}

void CDffDlg::LimitUVButtonClick()
{
    /* Handle enable/disable of limit UV value when radio button is clicked. */
    CWnd *maxuvtext=GetDlgItem(IDC_MAXUVTEXT);
    if (maxuvtext) {
        maxuvtext->EnableWindow(IsDlgButtonChecked(IDC_LIMITUVS));
    }
    CWnd *limituvsmax=GetDlgItem(IDC_LIMITUVSMAX);
    if (limituvsmax) {
        limituvsmax->EnableWindow(IsDlgButtonChecked(IDC_LIMITUVS));
    }
}

void CDffDlg::SaveMorphTargetsButtonClick()
{
    /* Handle enable/disable of morph target frame intervals when radio button
        is clicked. */
    CWnd *morphintervaltext=GetDlgItem(IDC_MORPHINTERVALTEXT);
    if (morphintervaltext) {
        morphintervaltext->EnableWindow(IsDlgButtonChecked(IDC_SAVEMORPHTARGETS));
    }
    CWnd *animframeinterval=GetDlgItem(IDC_ANIMFRAMEINTERVAL);
    if (animframeinterval) {
        animframeinterval->EnableWindow(IsDlgButtonChecked(IDC_SAVEMORPHTARGETS));
    }
}

void CDffDlg::LegacyOptionsButtonClick()
{
    /* Handle enable/disable of legacy options when radio button
        is clicked. */
    CWnd *defaulttext=GetDlgItem(IDC_ANIDEFNAMETEXT);
    if (defaulttext) {
        defaulttext->EnableWindow(IsDlgButtonChecked(IDC_LEGACYOPTIONS));
    }
    CWnd *defaultname=GetDlgItem(IDC_DEFAULTANIMNAME);
    if (defaultname) {
        defaultname->EnableWindow(IsDlgButtonChecked(IDC_LEGACYOPTIONS));
    }
    CWnd *linkverts=GetDlgItem(IDC_NAMEDSETVERTS);
    if (linkverts) {
        linkverts->EnableWindow(IsDlgButtonChecked(IDC_LEGACYOPTIONS));
    }
    CWnd *saveanim=GetDlgItem(IDC_SAVEANIM2);
    if (saveanim) {
        saveanim->EnableWindow(IsDlgButtonChecked(IDC_LEGACYOPTIONS));
    }
    CWnd *saveanimseq=GetDlgItem(IDC_SAVESEQANIM);
    if (saveanimseq) {
        saveanimseq->EnableWindow(IsDlgButtonChecked(IDC_LEGACYOPTIONS));
    }
}

BOOL CDffDlg::OnToolTipNotify( UINT id, NMHDR * pTTTStruct, LRESULT * pResult )
{
    TOOLTIPTEXT *pTTT = (TOOLTIPTEXT *)pTTTStruct;
    UINT nID =pTTTStruct->idFrom;
    if (pTTT->uFlags & TTF_IDISHWND)
    {
        // idFrom is actually the HWND of the tool
        nID = ::GetDlgCtrlID((HWND)nID);
        if(nID)
        {
            pTTT->lpszText = MAKEINTRESOURCE(nID);
            pTTT->hinst = AfxGetResourceHandle();
            return(TRUE);
        }
    }
    return(FALSE);
}

void CDffDlg::OnContextMenu(CWnd* pWnd, CPoint point) 
{
    //this is activated by a right click on a control
    char buffer[256];
    string helpfilename;

    //Find the location of the help file
    GetModuleFileName(GetModuleHandle("rw30exp.dle"),buffer,sizeof(buffer));
    //make the filename into "c:\\3dsmax3_1\\help\\rw30exp.chm"
    helpfilename=GetFilePath(buffer);
    helpfilename=GetParentDir(helpfilename);
    helpfilename=helpfilename+"\\help\\rw30exp.chm";
    
    try {
      HtmlHelp(
               pWnd->GetSafeHwnd(),
               helpfilename.c_str(),
               HH_DISPLAY_TOPIC,
               NULL) ;
    }
    catch (...) {
    }
}

BOOL CDffDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
    char buffer[256];
    string helpfilename;

    if (pHelpInfo->iContextType == HELPINFO_WINDOW)
    {
        //Find the location of the help file
        GetModuleFileName(GetModuleHandle("rw30exp.dle"),buffer,sizeof(buffer));
        //MUST open the .txt file with the mappings - this file is inside the .chm
        //make the filename into "c:\\3dsmax3_1\\help\\rw30exp.chm::cshelp.txt"
        helpfilename=GetFilePath(buffer);
        helpfilename=GetParentDir(helpfilename);
        helpfilename=helpfilename+"\\help\\rw30exp.chm::cshelp.txt";
        try {
            return HtmlHelp(
            (HWND)pHelpInfo->hItemHandle,
            helpfilename.c_str(),
            HH_TP_HELP_WM_HELP,
            (DWORD)(LPVOID)m_helpMappingArray)
            !=NULL;
        }
        catch (...) {
            return FALSE;
        }
    }
    return TRUE;
}

void CDffDlg::OnHelpButton() 
{
    string helpfilename;

    /* Load the icon for the help button. */
    HICON hIcon = ::LoadIcon (AfxGetResourceHandle(),
    MAKEINTRESOURCE(IDI_HELPICON));

    CWnd *helpbutton = GetDlgItem(IDC_HELPBUTTON);
    (CButton *)helpbutton->SetIcon( hIcon,FALSE );
    
    //button click procedure for help button
    char buffer[256];

    //Find the location of the help file
    GetModuleFileName(GetModuleHandle("rw30exp.dle"),buffer,sizeof(buffer));
    //make the filename into "c:\\3dsmax3_1\\help\\rw30exp.chm"
    helpfilename=GetFilePath(buffer);
    helpfilename=GetParentDir(helpfilename);
    helpfilename=helpfilename+"\\help\\rw30exp.chm";

    try {
      HtmlHelp(
               m_hWnd,
               helpfilename.c_str(),
               HH_DISPLAY_TOPIC,
               NULL) ;
    }
    catch (...) {
    }    
}

void CDffDlg::MaxNativeSkinButtonClick() 
{
	// Enable/Disable Save RpSkin SKA based on max native skin
    // and CSExport
    CWnd *SkinSKA=GetDlgItem(IDC_SKINSKA);
    if (SkinSKA) {
        SkinSKA->EnableWindow(IsDlgButtonChecked(IDC_MAXNATIVESKIN) ||
                              IsDlgButtonChecked(IDC_CSEXPORT));
    }
	
}

void CDffDlg::CSExportButtonClick() 
{
	// Enable/Disable Save RpSkin SKA based on max native skin
    // and CSExport
    CWnd *SkinSKA=GetDlgItem(IDC_SKINSKA);
    if (SkinSKA) {
        SkinSKA->EnableWindow(IsDlgButtonChecked(IDC_MAXNATIVESKIN) ||
                              IsDlgButtonChecked(IDC_CSEXPORT));
    }
	
    // Enable/Disable filter of CS keys
    CWnd *CSExportKeys=GetDlgItem(IDC_CSTOPLEVELKEYS);
    if (CSExportKeys) {
        CSExportKeys->EnableWindow(IsDlgButtonChecked(IDC_CSEXPORT));
    }        

}

